%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% mfile to solve of "Integrated design with UIO"
% Jianglin Lan, 2015-0903, function file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sys_state = Norminal_control_closed_sys_performance(t,xx,A,B,Fa,D,C,Fs,Delta_A,Ko,M,G,L,H)
hat_eta = xx(1);
xi1 = xx(2);
xi2 = xx(3);
xi3 = xx(4);
xi4 = xx(5);
x1 = xx(6);
x2 = xx(7);

global Intn_ts Intn_count Intn_tmp Intn_hatfa Intn_hatfs Intn_yy1 Intn_yy2


Y = 0.5*ones(1,2);
N = pinv(C*B) - Y * (eye(2) - C*B*pinv(C*B));

psi = 0.001; omega =  16.4073; 
phi = omega*psi + 0.01;

varep1 = 0.01; varep2 = 1.0e-3; 
sigma = 0.1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% disturbance and fault
d = 0.01 * sin(t);
fa = piecewise_fa(t); 
fs = piecewise_fs(t); % 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x = [x1;x2];
y = C*x + Fs*fs;
xi = [xi1;xi2;xi3;xi4];
hat_x = xi + H*y;

% sliding surface
yc = y;
s_t = N*yc;

% controller
u_l = - [Ko 0 0]*hat_x;
rho2 = hat_eta + varep1 + phi;

u_n = -rho2 * (s_t / (norm(s_t,2) + varep2));

u = u_l + u_n;

dot_hat_eta = sigma * norm(s_t,2);

%observer
dot_xi = M* xi + G*u + L*y;

% sys dynamic
dot_x = (A + Delta_A)*x + B*u + Fa*fa + D*d;


% data saving 
if mod(Intn_tmp,28)==0
    Intn_count = Intn_count + 1;
Intn_ts(Intn_count) = t;
Intn_hatfa(Intn_count) = fa - hat_x(3);
Intn_hatfs(Intn_count) = fs - hat_x(4);
Intn_yy1(Intn_count) = yc(1);
Intn_yy2(Intn_count) = yc(2);
% Intn_s(Intn_count) = u;
end
Intn_tmp = Intn_tmp + 1;

sys_state = [dot_hat_eta;dot_xi;dot_x];